/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit adder with carryIn
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_add8 (cout, s, a, b, cin);
  output[7:0]	s;
  output	cout;
  input[7:0]	a, b;
  input		cin;
 
  reg[7:0]	s_int;
  reg		cout_int;
 
  buf #1 (cout, cout_int);
  buf #1 (s[0], s_int[0]);
  buf #1 (s[1], s_int[1]);
  buf #1 (s[2], s_int[2]);
  buf #1 (s[3], s_int[3]);
  buf #1 (s[4], s_int[4]);
  buf #1 (s[5], s_int[5]);
  buf #1 (s[6], s_int[6]);
  buf #1 (s[7], s_int[7]);
 
  always @(a or b or cin)
    assign {cout_int, s_int} = a + b + cin;

  specify

`ifdef SYNTH
	specparam area = 16;
`endif

  endspecify

endmodule
`endcelldefine



/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit barrel shifter with parallel load
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_barrel8l_ldst(q, clk, d, ldst, shift);
  output[7:0]	q;
  input[7:0]	d;
  input		clk, ldst, shift;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  always @(posedge clk)
	/* load */
	if ( ldst )
		q_int = d;
	/* shift right */
	else if ( shift )
		q_int = { q_int[6:0], q_int[7] };

  specify

`ifdef SYNTH
	specparam area = 4;
`endif

  endspecify
 
endmodule
`endcelldefine



/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit barrel shifter with parallel load
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_barrel8r_ldst(q, clk, d, ldst, shift);
  output[7:0]	q;
  input[7:0]	d;
  input		clk, ldst, shift;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  always @(posedge clk)
	/* load */
	if ( ldst )
		q_int = d;
	/* shift right */
	else if ( shift )
		q_int = { q_int[0], q_int[7:1] };

  specify

`ifdef SYNTH
	specparam area = 4;
`endif

  endspecify
 
endmodule
`endcelldefine








/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 4 bit up/down (dnup) counter with
		 async clear (clrn)
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_count4_dnup_clrn(cout, q, cin, clk, clrn, dnup);
  output[3:0]	q;
  output	cout;
  input		cin, clk, clrn, dnup;

  reg[3:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
 
  assign cout = ( ( dnup & ( q_int == 4'b0 ) ) | ( !dnup & ( q_int == 4'b1111 ) ) );

  always @(posedge clk)
	/* decrement */
	if ( dnup & cin )
		q_int = q_int - 1;
	/* increment */
	else if ( !dnup & cin )
		q_int = q_int + 1;

  always @(clrn)
	if (!clrn) /* async clear */
		assign q_int = 4'b0;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 7;
`endif

  endspecify
 
endmodule
`endcelldefine







/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 4 bit up/down (dnup) counter with
		 async clear (clrn), and sync load (ldn)
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_count4_dnup_ldn_clrn(cout, q, cin, clk, clrn, d, dnup, ldn);
  output[3:0]	q;
  output	cout;
  input[3:0]	d;
  input		cin, clk, clrn, dnup, ldn;

  reg[3:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
 
  assign cout = ( ( dnup & ( q_int == 4'b0 ) ) | ( !dnup & ( q_int == 4'b1111 ) ) );

  always @(posedge clk)
	/* load */
	if ( !ldn )
		q_int = d;
	/* decrement */
	else if ( dnup & cin )
		q_int = q_int - 1;
	/* increment */
	else if ( !dnup & cin )
		q_int = q_int + 1;

  always @(clrn)
	if (!clrn) /* async clear */
		assign q_int = 4'b0;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 7;
`endif

  endspecify
 
endmodule
`endcelldefine







/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 4 bit up/down (dnup) counter with async set (setn)
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_count4_dnup_setn(cout, q, cin, clk, d, dnup, setn);
  output[3:0]	q;
  output	cout;
  input[3:0]	d;
  input		cin, clk, dnup, setn;

  reg[3:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
 
  assign cout = ( ( dnup & ( q_int == 4'b0 ) ) | ( !dnup & ( q_int == 4'b1111 ) ) );

  always @(posedge clk)
        /* decrement */
        if ( dnup & cin )
                q_int = q_int - 1;
        /* increment */
        else if ( !dnup & cin )
                q_int = q_int + 1;

  always @(setn)
	if (!setn) /* async load */
		assign q_int = d;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 7;
`endif

  endspecify
 
endmodule
`endcelldefine



/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit up/down (dnup) counter with gate enable (gn) and
		 async clear (clrn)
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_count8_dnup_clrn(cout, q, clk, clrn, dnup, gn);
  output[7:0]	q;
  output	cout;
  input		clk, clrn, dnup, gn;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  assign cout = ( ( dnup & !gn & ( q_int == 8'b0 ) ) | ( !dnup & !gn & ( q_int == 8'b11111111 ) ) );

  always @(posedge clk)
	if ( dnup & !gn )
		q_int = q_int - 1;
	/* increment */
	else if ( !dnup & !gn )
		q_int = q_int + 1;

  always @(clrn)
	if (!clrn) /* async clear */
		assign q_int = 8'b0;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 14;
`endif

  endspecify
 
endmodule
`endcelldefine



/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit up/down (dnup) counter with gate enable (gn), 
		 async clear (clrn), and sync load (ldn)
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_count8_dnup_ldn_clrn(cout, q, clk, clrn, d, dnup, gn, ldn);
  output[7:0]	q;
  output	cout;
  input[7:0]	d;
  input		clk, clrn, dnup, gn, ldn;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  assign cout = ( ( dnup & !gn & ( q_int == 8'b0 ) ) | ( !dnup & !gn & ( q_int == 8'b11111111 ) ) );

  always @(posedge clk)
	/* load */
	if ( !ldn )
		q_int = d;
	/* decrement */
	else if ( dnup & !gn )
		q_int = q_int - 1;
	/* increment */
	else if ( !dnup & !gn )
		q_int = q_int + 1;

  always @(clrn)
	if (!clrn) /* async clear */
		assign q_int = 8'b0;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 14;
`endif

  endspecify
 
endmodule
`endcelldefine



/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit up/down (dnup) counter with gate enable (gn), 
		 and async set (setn)
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_count8_dnup_setn(cout, q, clk, d, dnup, gn, setn);
  output[7:0]	q;
  output	cout;
  input[7:0]	d;
  input		clk, dnup, gn, setn;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  assign cout = ( ( dnup & !gn & ( q_int == 8'b0 ) ) | ( !dnup & !gn & ( q_int == 8'b11111111 ) ) );

  always @(posedge clk)
        /* decrement */
        if ( dnup & !gn )
                q_int = q_int - 1;
        /* increment */
        else if ( !dnup & !gn )
                q_int = q_int + 1;

  always @(setn)
	if (!setn) /* async load */
		assign q_int = d;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 14;
`endif

  endspecify
 
endmodule
`endcelldefine



/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module a_gnd (y);
	output
		y;
 
        parameter cds_supply = "gnd";
 
	supply0
		y;
specify
        // Synthesis parameters
        `ifdef SYNTH
        specparam area = 0;
        `endif
endspecify

endmodule
`endcelldefine

/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 16 to 1 multiplexer
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_mux161 (y, a, b, c, d, d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15);
  output	y;
  input		a, b, c, d, d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15;

  reg		y_int;

  buf #1 (y, y_int);
 
  always @(a or b or c or d or d0 or d1 or d2 or d3 or d4 or d5 or d6 or d7 or d8 or d9 or d10 or d11 or d12 or d13 or d14 or d15)
	case ( {d,c,b,a})
		4'b0000: assign y_int = d0;
		4'b0001: assign y_int = d1;
		4'b0010: assign y_int = d2;
		4'b0011: assign y_int = d3;
		4'b0100: assign y_int = d4;
		4'b0101: assign y_int = d5;
		4'b0110: assign y_int = d6;
		4'b0111: assign y_int = d7;
		4'b1000: assign y_int = d8;
		4'b1001: assign y_int = d9;
		4'b1010: assign y_int = d10;
		4'b1011: assign y_int = d11;
		4'b1100: assign y_int = d12;
		4'b1101: assign y_int = d13;
		4'b1110: assign y_int = d14;
		4'b1111: assign y_int = d15;
	endcase

  specify

`ifdef SYNTH
	specparam area = 14;
`endif

  endspecify
 
endmodule
`endcelldefine


/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 2 bit multiplexer
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_mux21 (y, a, b, s);
  output	y;
  input		a, b, s;
 
  wire y_int;
 
  buf (y, y_int);
  assign y_int = (s == 1) ? a : b;

  specify

`ifdef SYNTH
	specparam area = 1;
`endif

      // Specify path delays

	(a *> y) = (1, 1);
	(b *> y) = (1, 1);
	(s *> y) = (1, 1);

  endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 2 8 bit bus multiplexer
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_mux2x8 (y, a, b, s);
  output[7:0]	y;
  input[7:0]	a, b;
  input		s;
 
  wire[7:0] y_int;
 
  buf #1 (y[0], y_int[0]);
  buf #1 (y[1], y_int[1]);
  buf #1 (y[2], y_int[2]);
  buf #1 (y[3], y_int[3]);
  buf #1 (y[4], y_int[4]);
  buf #1 (y[5], y_int[5]);
  buf #1 (y[6], y_int[6]);
  buf #1 (y[7], y_int[7]);

  assign y_int[7:0] = (s == 1) ? a[7:0] : b[7:0];

  specify

`ifdef SYNTH
	specparam area = 8;
`endif

  endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 to 1 multiplexer
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_mux81 (wn, y, a, b, c, d0, d1, d2, d3, d4, d5, d6, d7);
  output	wn, y;
  input		a, b, c, d0, d1, d2, d3, d4, d5, d6, d7;

  reg		y_int;

  buf #1 (y, y_int);
  not #1 (wn, y_int);
 
  always @(a or b or c or d0 or d1 or d2 or d3 or d4 or d5 or d6 or d7)
	case ( {c,b,a})
		3'b000: assign y_int = d0;
		3'b001: assign y_int = d1;
		3'b010: assign y_int = d2;
		3'b011: assign y_int = d3;
		3'b100: assign y_int = d4;
		3'b101: assign y_int = d5;
		3'b110: assign y_int = d6;
		3'b111: assign y_int = d7;
	endcase

  specify

`ifdef SYNTH
	specparam area = 7;
`endif

  endspecify
 
endmodule
`endcelldefine


/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit shifter register
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_shift8l_ldst(q, clk, clrn, d, ldst, shift, sin);
  output[7:0]	q;
  input[7:0]	d;
  input		clk, clrn, ldst, sin, shift;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  always @(posedge clk)
	if ( ldst )
		q_int = d;
	else if ( shift )
		q_int = { q_int[6:0], sin };

  always @(clrn)
	if (!clrn) /* async clear */
		assign q_int = 8'b0;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 4;
`endif

  endspecify
 
endmodule
`endcelldefine



/******************************************************************************
* This Program is the Confidential and Proprietary product of Cadence Design  *
* Systems. Any unauthorized use,  reproduction or transfer of this program is *
* strictly prohibited. Copyright (c)  1990, 1991, 1992, 1993, 1994 and 1995   *
* by Cadence Design Systems .                                                 *
* All Rights Reserved.                                                        *
*******************************************************************************/

/*

LIBRARY        : Altera synthesis library
FUNCTION       : 8 bit shifter register
                 
DESIGNER       : Udi Landen
DATE GENERATED : 8th Jan 1995 

VERITOOL COMPATIBILITY : Verilog2.0, Veritime1.4

*/
      
`timescale  1 ns / 100 ps 
`celldefine     
module a_shift8r_ldst(q, clk, clrn, d, ldst, shift, sin);
  output[7:0]	q;
  input[7:0]	d;
  input		clk, clrn, ldst, sin, shift;

  reg[7:0]	q_int;

  buf #1 (q[0], q_int[0]);
  buf #1 (q[1], q_int[1]);
  buf #1 (q[2], q_int[2]);
  buf #1 (q[3], q_int[3]);
  buf #1 (q[4], q_int[4]);
  buf #1 (q[5], q_int[5]);
  buf #1 (q[6], q_int[6]);
  buf #1 (q[7], q_int[7]);
 
  always @(posedge clk)
	if ( ldst )
		q_int = d;
	else if ( shift )
		q_int = { sin, q_int[7:1] };

  always @(clrn)
	if (!clrn) /* async clear */
		assign q_int = 8'b0;
	else
		deassign q_int;

  specify

`ifdef SYNTH
	specparam area = 4;
`endif

  endspecify
 
endmodule
`endcelldefine



/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module a_tri (y, oe, a);
	parameter size =1;
	input
		oe,
		a;
	output
		y;
    bufif1 #1  
	 (y, a, oe);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$oe = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (oe => y) = (0.000,0.000,1.0,1.0,1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module a_vcc (y);
	output
		y;

	parameter cds_supply = "vcc";

	supply1
		y;

specify
       // Synthesis parameters
        `ifdef SYNTH
        specparam area = 0;
        `endif
endspecify

endmodule
`endcelldefine

/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module and12 (y, a, b, c, d, e, f, g, h, i, j, k, l);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h,
		i,
		j,
		k,
		l;
	output
		y;
    and  
	  (y, a, b, c, d, e, f, g, h, i, j, k, l);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 4;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
     	specparam capacitance$g = 1;
     	specparam capacitance$h = 1;
     	specparam capacitance$i = 1;
     	specparam capacitance$j = 1;
     	specparam capacitance$k = 1;
     	specparam capacitance$l = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);
    (g => y) = (1.0,1.0);
    (h => y) = (1.0,1.0);
    (i => y) = (1.0,1.0);
    (j => y) = (1.0,1.0);
    (k => y) = (1.0,1.0);
    (l => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module and2 (y, a, b);
	parameter size =1;
	input
		a,
		b;
	output
		y;
    and  
	  (y, a, b);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
	    specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module and3 (y, a, b, c);
	parameter size =1;
	input
		a,
		b,
		c;
	output
		y;
    and  
	  (y, a, b, c);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module and4 (y, a, b, c, d);
	parameter size =1;
	input
		a,
		b,
		c,
		d;
	output
		y;
    and  
	  (y, a, b, c, d);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module and6 (y, a, b, c, d, e, f);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f;
	output
		y;
    and  
	 (y, a, b, c, d, e, f);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 2;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module and8 (y, a, b, c, d, e, f, g, h);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h;
	output
		y;
    and  
	  (y, a, b, c, d, e, f, g, h);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 3;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
     	specparam capacitance$g = 1;
     	specparam capacitance$h = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);
    (g => y) = (1.0,1.0);
    (h => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is          *
* strictly prohibited. Copyright (c)  1993  by Altera Corp.                   *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; January 93
FUNCTION       : carry cell 
TRUTHTABLE     : 
          ------------
          a   |  y
          ------------ 
           H   |   H
           L   |   L
          ------------ 
REFERENCE      : Altera Design Guide
DESIGNER       : Ami Vider
DATE GENERATED : January 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module carry (y, a);
	parameter size =1;
	input
		a;
	output
		y;
    buf (y, a);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam area = 1;
`endif


        (a -=>  y) = (1, 1);

    endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is          *
* strictly prohibited. Copyright (c)  1993  by Altera Corp.                   *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; January 93
FUNCTION       : cascade cell 
TRUTHTABLE     : 
          ------------
          a   |  y
          ------------ 
           H   |   H
           L   |   L
          ------------ 
REFERENCE      : Altera Design Guide
DESIGNER       : Ami Vider
DATE GENERATED : January 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module cascade (y, a);
	parameter size =1;
	input
		a;
	output
		y;
    buf (y, a);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam area = 1;
`endif


        (a -=>  y) = (1, 1);

    endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 

          ----------------------------
          D    clk   clrn  prn   q
          ----------------------------
                 _
          L    _/     H    H      L   
                 _
          H    _/     H    H      H  
                
          X     L     H    H      qo 
          
          X     X     L    H      L

          X     X     H    L      H

          X     X     L    L     illegal 

          ----------------------------- 
*/
`celldefine
`timescale 1ns / 100ps
module dff (q, d, clk, clrn, prn);
	parameter size =1;
	input
		d,
		clrn,
		prn,
		clk;
	output
		q;

	reg r_q;
	buf (q, r_q);

  	always @(posedge clk)
    	r_q = d;

  	always @(clrn or prn)
    	if (clrn == 0) 
        	assign r_q = 0;
    	else if (prn == 0)
            assign r_q = 1;
    	else
        	deassign r_q;

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$clk = 1;
     	specparam capacitance$clrn = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$prn = 1;
	`endif

    // Timing Checks
    $hold(posedge clk,d,1.0);
    $setup(d,posedge clk,1.0);

    // Path Delays
       if (clrn && prn)
            (posedge clk => (q +: d)) = (1, 1);

       (negedge clrn => (q +: 1'b0)) = (1, 1);
       (negedge prn => (q +: 1'b1)) = (1, 1);

endspecify
endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 

          ----------------------------
          D    clk   clrn  prn ena  q
          ----------------------------
                 
          X     X     H    H   L    q0  
                 _
          L    _/     H    H   H    L   
                 _
          H    _/     H    H   H    H  
                
          X     L     H    H   X    qo 
          
          X     X     L    H   X    L

          X     X     H    L   X    H

          X     X     L    L   X    illegal 

          ----------------------------- 
*/
`celldefine
`timescale 1ns / 100ps
module dffe (q, d, clk, clrn, ena, prn);
	parameter size =1;
	input
		d,
		clrn,
		ena,
		prn,
		clk;
	output
		q;

	reg r_q;
	buf (q, r_q);

  	always @(posedge clk)
		if (ena) r_q = d;

  	always @(clrn or prn)
    	if (clrn == 0) 
        	assign r_q = 0;
    	else if (prn == 0)
            assign r_q = 1;
    	else
        	deassign r_q;

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$clk = 1;
     	specparam capacitance$clrn = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$prn = 1;
     	specparam capacitance$ena = 1;
	`endif

    // Timing Checks
    $hold(posedge clk,d,1.0);
    $setup(d,posedge clk,1.0);

    // Path Delays
       if (clrn && prn && ena) 
            (posedge clk => (q +: d)) = (1, 1);

       (negedge clrn => (q +: 1'b0)) = (1, 1);
       (negedge prn => (q +: 1'b1)) = (1, 1);

endspecify
endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is          *
* strictly prohibited. Copyright (c)  1993  by Altera Corp.                   *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; January 93
FUNCTION       : expander product term cell 
TRUTHTABLE     : 
          ------------
          a   |  y
          ------------ 
           H   |   H
           L   |   L
          ------------ 
REFERENCE      : Altera Design Guide
DESIGNER       : Ami Vider
DATE GENERATED : January 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module exp (y, a);
	parameter size =1;
	input
		a;
	output
		y;
    buf (y, a);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam area = 1;
`endif


        (a -=>  y) = (1, 1);

    endspecify

endmodule
`endcelldefine


/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is          *
* strictly prohibited. Copyright (c)  1993  by Altera Corp.                   *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; January 93
FUNCTION       : global clock cell 
TRUTHTABLE     : 
          ------------
          a   |  y
          ------------ 
           H   |   H
           L   |   L
          ------------ 
REFERENCE      : Altera Design Guide
DESIGNER       : Ami Vider
DATE GENERATED : January 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module global (y, a);
	parameter size =1;
	input
		a;
	output
		y;
    buf (y, a);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam area = 1;
`endif


        (a -=>  y) = (1, 1);

    endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module inv (y, a);
	parameter size =1;
	input
		a;
	output
		y;
    not 
	  (y, a);

specify
	
	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 
          ----------------
           ena	d   |   q
          ---------------- 
           H   	L	|   L
           H   	H	|   H
           L   	X	|   q
          ---------------- 
*/
`celldefine

`timescale  1ns /  100ps
module latch (q, ena, d);
	parameter size =1;
	input
		ena,
		d;
	output
		q;

  reg r_q;
  buf #1 (q,  r_q);

  always @(d or ena)
        if (ena == 1)
            r_q = d;

specify
     specparam area = 1;
     specparam capacitance$d = 1;
     specparam capacitance$ena = 1;

    // Timing Checks
    $hold(posedge ena,d,1.0);
    $setup(d,posedge ena,1.0);

    // Path Delays
    (d => q) = (1.0,1.0);
    (ena => q) = (1.0,1.0);
endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 
          --------------------
           ena	d  clrn |   q
          -------------------- 
           X   	X  L	|   L
           H   	L  H	|   L
           H   	H  H	|   H
           L   	X  H	|   q
          -------------------- 
*/
`celldefine

`timescale  1ns /  100ps
module latch_clrn (q, clrn, d, ena);
	parameter size =1;
	input
		ena,
		clrn,
		d;
	output
		q;

  reg r_q;
  buf (q,  r_q);

  always @(d or ena)
        if (ena == 1)
            r_q = d;

  always @(clrn)
	if (!clrn)
		assign r_q = 1'b0;
	else
		deassign r_q;

specify
     specparam area = 2;
     specparam capacitance$d = 1;
     specparam capacitance$ena = 1;
     specparam capacitance$clrn = 1;

    // Timing Checks
    $hold(posedge ena,d,1.0);
    $setup(d,posedge ena,1.0);

    // Path Delays
    (d => q) = (1.0,1.0);
    (ena => q) = (1.0,1.0);
    (clrn => q) = (1.0,1.0);
endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 
          --------------------
           ena	d  setn |   q
          -------------------- 
           X   	X  L	|   H
           H   	L  H	|   L
           H   	H  H	|   H
           L   	X  H	|   q
          -------------------- 
*/
`celldefine

`timescale  1ns /  100ps
module latch_setn (q, d, ena, setn);
	parameter size =1;
	input
		ena,
		setn,
		d;
	output
		q;

  reg r_q;
  buf (q,  r_q);

  always @(d or ena)
        if (ena == 1)
            r_q = d;

  always @(setn)
	if (!setn)
		assign r_q = 1'b1;
	else
		deassign r_q;

specify
     specparam area = 2;
     specparam capacitance$d = 1;
     specparam capacitance$ena = 1;
     specparam capacitance$setn = 1;

    // Timing Checks
    $hold(posedge ena,d,1.0);
    $setup(d,posedge ena,1.0);

    // Path Delays
    (d => q) = (1.0,1.0);
    (ena => q) = (1.0,1.0);
    (setn => q) = (1.0,1.0);
endspecify

endmodule
`endcelldefine
/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is          *
* strictly prohibited. Copyright (c)  1993  by Altera Corp.                   *
*  All Rights Reserved.                                                       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; January 93
FUNCTION       : logic cell 
TRUTHTABLE     : 
          ------------
          a   |  y
          ------------ 
           H   |   H
           L   |   L
          ------------ 
REFERENCE      : Altera Design Guide
DESIGNER       : Ami Vider
DATE GENERATED : January 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog 1.5c, Veritime 1.1a

*/
`celldefine

`timescale  1ns /  100ps
module lcell (y, a);
	parameter size =1;
	input
		a;
	output
		y;
    buf (y, a);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam area = 1;
`endif


        (a -=>  y) = (1, 1);

    endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nand12 (y, a, b, c, d, e, f, g, h, i, j, k, l);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h,
		i,
		j,
		k,
		l;
	output
		y;
    nand  
	  (y, a, b, c, d, e, f, g, h, i, j, k, l);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 4;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
     	specparam capacitance$g = 1;
     	specparam capacitance$h = 1;
     	specparam capacitance$i = 1;
     	specparam capacitance$j = 1;
     	specparam capacitance$k = 1;
     	specparam capacitance$l = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);
    (g => y) = (1.0,1.0);
    (h => y) = (1.0,1.0);
    (i => y) = (1.0,1.0);
    (j => y) = (1.0,1.0);
    (k => y) = (1.0,1.0);
    (l => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nand2 (y, a, b);
	parameter size =1;
	input
		a,
		b;
	output
		y;
    nand
	  (y, a, b);

specify

	// Synthesis parameters
	`ifdef SYNTH
    	specparam area = 1;
	    specparam capacitance$a = 1;
   	 	specparam capacitance$b = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nand3 (y, a, b, c);
	parameter size =1;
	input
		a,
		b,
		c;
	output
		y;
    nand  
	  (y, a, b, c);

specify

	// Synthesis parameters
	`ifdef SYNTH
  	    specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine

/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nand4 (y, a, b, c, d);
	parameter size =1;
	input
		a,
		b,
		c,
		d;
	output
		y;
    nand  
	  (y, a, b, c, d);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nand6 (y, a, b, c, d, e, f);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f;
	output
		y;
    nand  
	 (y, a, b, c, d, e, f);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 2;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nand8 (y, a, b, c, d, e, f, g, h);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h;
	output
		y;
    nand  
	  (y, a, b, c, d, e, f, g, h);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 3;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
     	specparam capacitance$g = 1;
     	specparam capacitance$h = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);
    (g => y) = (1.0,1.0);
    (h => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nor12 (y, a, b, c, d, e, f, g, h, i, j, k, l);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h,
		i,
		j,
		k,
		l;
	output
		y;
    nor  
	  (y, a, b, c, d, e, f, g, h, i, j, k, l);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 4;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
     	specparam capacitance$g = 1;
     	specparam capacitance$h = 1;
     	specparam capacitance$i = 1;
     	specparam capacitance$j = 1;
     	specparam capacitance$k = 1;
     	specparam capacitance$l = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);
    (g => y) = (1.0,1.0);
    (h => y) = (1.0,1.0);
    (i => y) = (1.0,1.0);
    (j => y) = (1.0,1.0);
    (k => y) = (1.0,1.0);
    (l => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nor2 (y, a, b);
	parameter size =1;
	input
		a,
		b;
	output
		y;
    nor  
	  (y, a, b);
specify

	// Synthesis parameters
	`ifdef SYNTH
	    specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine

/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nor3 (y, a, b, c);
	parameter size =1;
	input
		a,
		b,
		c;
	output
		y;
    nor  
	  (y, a, b, c);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nor4 (y, a, b, c, d);
	parameter size =1;
	input
		a,
		b,
		c,
		d;
	output
		y;
    nor  
	  (y, a, b, c, d);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nor6 (y, a, b, c, d, e, f);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f;
	output
		y;
    nor  
	 (y, a, b, c, d, e, f);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 2;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module nor8 (y, a, b, c, d, e, f, g, h);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h;
	output
		y;
    nor  
	  (y, a, b, c, d, e, f, g, h);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 3;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
     	specparam capacitance$g = 1;
     	specparam capacitance$h = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);
    (g => y) = (1.0,1.0);
    (h => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module or12 (y, a, b, c, d, e, f, g, h, i, j, k, l);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h,
		i,
		j,
		k,
		l;
	output
		y;
    or  
	  (y, a, b, c, d, e, f, g, h, i, j, k, l);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 4;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
     	specparam capacitance$g = 1;
     	specparam capacitance$h = 1;
     	specparam capacitance$i = 1;
     	specparam capacitance$j = 1;
     	specparam capacitance$k = 1;
     	specparam capacitance$l = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);
    (g => y) = (1.0,1.0);
    (h => y) = (1.0,1.0);
    (i => y) = (1.0,1.0);
    (j => y) = (1.0,1.0);
    (k => y) = (1.0,1.0);
    (l => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module or2 (y, a, b);
	parameter size =1;
	input
		a,
		b;
	output
		y;
    or  
	  (y, a, b);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module or3 (y, a, b, c);
	parameter size =1;
	input
		a,
		b,
		c;
	output
		y;
    or  
	  (y, a, b, c);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module or4 (y, a, b, c, d);
	parameter size =1;
	input
		a,
		b,
		c,
		d;
	output
		y;
    or  
	  (y, a, b, c, d);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module or6 (y, a, b, c, d, e, f);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f;
	output
		y;
    or  
	 (y, a, b, c, d, e, f);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 2;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine

`timescale  1ns /  100ps
module or8 (y, a, b, c, d, e, f, g, h);
	parameter size =1;
	input
		a,
		b,
		c,
		d,
		e,
		f,
		g,
		h;
	output
		y;
    or  
	  (y, a, b, c, d, e, f, g, h);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 3;
     	specparam capacitance$a = 1;
     	specparam capacitance$b = 1;
     	specparam capacitance$c = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$e = 1;
     	specparam capacitance$f = 1;
     	specparam capacitance$g = 1;
     	specparam capacitance$h = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
    (c => y) = (1.0,1.0);
    (d => y) = (1.0,1.0);
    (e => y) = (1.0,1.0);
    (f => y) = (1.0,1.0);
    (g => y) = (1.0,1.0);
    (h => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 
          ------------
          a   |  y
          ------------ 
           H   |   H
           L   |   L
          ------------ 
*/
`celldefine

`timescale  1ns /  100ps
module soft (y, a);
	parameter size =1;
	input
		a;
	output
		y;
    buf (y, a);

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$a = 1;
	`endif

    // Path Delays
    (a => y) = (1.0,1.0);

endspecify

endmodule
`endcelldefine

/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*

FUNCTION       : T FLIP-FLOPS WITH ASYNC PRESET AND CLEAR
TRUTHTABLE     : 

              --------------------------------
              prn  clrn   clk    T       q    
              --------------------------------
               L     H      X    X       H 

               H     L      X    X       L
                             _ 
               H     H     _/    L       q 
                             _
               H     H     _/    H       qb
                              
               H     H      L    X       q
              ------------------------------------
*/
`celldefine

`timescale  1ns /  100ps
module tff (clk, prn, clrn, t, q);
	parameter size =1;
	input
		clk,
		prn,
		clrn,
		t;
	output
		q;
    reg
        NOTIFY_REG1;
  reg r_q;
  buf (q,  r_q);

  always @(posedge clk)
    if (t)
	r_q = ~r_q;
    else
	r_q = r_q;
		
  always @(clrn or prn)
    if (clrn == 0)
        assign r_q = 0;
    else if (prn == 0)
            assign r_q = 1;
    else
        deassign r_q;

specify

    // Synthesis parameters
    `ifdef SYNTH
        specparam area = 1;
        specparam capacitance$clk = 1;
        specparam capacitance$clrn = 1;
        specparam capacitance$prn = 1;
        specparam capacitance$t = 1;
    `endif

    // Timing Checks
    $hold(posedge clk,t,1.0);
    $setup(t,posedge clk,1.0);

    // Path Delays
    (clk => q) = (1.0,1.0);
    (prn => q) = (1.0,1.0);
    (clrn => q) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
`celldefine
 
`timescale  1ns /  100ps
module xor2 (y, a, b);
        parameter size =1;
        input
                a,
                b;
        output
                y;
    xor  
          (y, a, b);
 
specify
 
        // Synthesis parameters
        `ifdef SYNTH
        specparam area = 1;
        specparam capacitance$a = 1;
        specparam capacitance$b = 1;
        `endif
 
    // Path Delays
    (a => y) = (1.0,1.0);
    (b => y) = (1.0,1.0);
 
endspecify
 
endmodule
`endcelldefine
